<?php

namespace Nuwave\Lighthouse\Support\Http\Middleware;

use Illuminate\Http\Request;
use Psr\Log\LoggerInterface;

/**
 * Logs every incoming GraphQL query.
 */
class LogGraphQLQueries
{
    public const MESSAGE = 'Received GraphQL query';

    /**
     * @var \Psr\Log\LoggerInterface
     */
    protected $logger;

    public function __construct(LoggerInterface $logger)
    {
        $this->logger = $logger;
    }

    /**
     * @return mixed Any kind of response
     */
    public function handle(Request $request, \Closure $next)
    {
        $this->logger->info(
            self::MESSAGE,
            $request->json()->all()
        );

        return $next($request);
    }
}
