<?php

namespace Marvel\Database\Seeders;

use Carbon\Carbon;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Marvel\Database\Models\Shop;

class FaqSeeder extends Seeder
{
    private array $shops;

    public function __construct()
    {
        $this->shops = Shop::all()->pluck("name", "id")->toArray();
    }
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        DB::table('faqs')->insert([
            [
                "user_id" => 1,
                "shop_id" => null,
                "faq_title" => "What is your return policy?",
                "slug" => "what-is-your-return-policy",
                "faq_description" => "We have a flexible return policy. If you're not satisfied with your purchase, you can return most items within 30 days for a full refund or exchange. Please review our Return Policy for more details.",
                "faq_type" => "global",
                "issued_by" => "Super Admin",
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            [
                "user_id" => 1,
                "shop_id" => null,
                "faq_title" => "Can I track my order?",
                "slug" => "can-i-track-my-order",
                "faq_description" => "Yes, you can track your order's status. Once your order is shipped, you will receive a tracking number via email. You can use this tracking number to monitor the progress of your delivery.",
                "faq_type" => "global",
                "issued_by" => "Super Admin",
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            [
                "user_id" => 1,
                "shop_id" => null,
                "faq_title" => "How long will it take to receive my order?",
                "slug" => "how-long-will-it-take-to-receive-my-order",
                "faq_description" => "Delivery times may vary depending on your location and the shipping method you choose. Typically, orders are processed and shipped within 1-2 business days. You can check the estimated delivery time during checkout.",
                "faq_type" => "global",
                "issued_by" => "Super Admin",
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            [
                "user_id" => 1,
                "shop_id" => null,
                "faq_title" => "What payment methods do you accept?",
                "slug" => "what-payment-methods-do-you-accept",
                "faq_description" => "We accept a variety of payment methods, including credit cards (Visa, MasterCard, American Express), PayPal, and more. You can choose your preferred payment option during the checkout process.",
                "faq_type" => "global",
                "issued_by" => "Super Admin",
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            [
                "user_id" => 1,
                "shop_id" => null,
                "faq_title" => "How can I place an order?",
                "slug" => "how-can-i-place-an-order",
                "faq_description" => "To place an order, simply browse our online store, add the items you want to your cart, and proceed to checkout. Follow the prompts to enter your shipping information and payment details to complete your purchase.",
                "faq_type" => "global",
                "issued_by" => "Super Admin",
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            ...$this->shopFAQsSeeder(),
            // ...$this->shopFAQsSeederGerman(),

        ]);
    }

    /**
     * shopFAQsSeeder
     *
     * @return array
     */
    private function shopFAQsSeeder(): array
    {
        return [
            [
                "user_id" => 1,
                "shop_id" => 1,
                "faq_title" => "What is the delivery process for furniture purchases?",
                "slug" => "what-is-the-delivery-process-for-furniture-purchases?",
                "faq_description" => "We offer convenient and reliable furniture delivery services. After making your purchase, our team will contact you to schedule a delivery time that suits your availability. Our delivery professionals will assemble and set up the furniture in your desired room. Please refer to our Delivery Information page for more details. ",
                "faq_type" => "shop",
                "issued_by" => $this->shops[1] ?? '',
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            [
                "user_id" => 1,
                "shop_id" => 1,
                "faq_title" => "Do you provide warranty coverage for furniture items?",
                "slug" => "do-you-provide-warranty-coverage-for-furniture-items?",
                "faq_description" => "Yes, many of our furniture items come with manufacturer warranties that cover structural defects and craftsmanship issues. The duration and terms of the warranty may vary by product. You can find warranty information in the product descriptions, or you can contact our customer support team for specific details. ",
                "faq_type" => "shop",
                "issued_by" => $this->shops[1] ?? '',
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            [
                "user_id" => 1,
                "shop_id" => 2,
                "faq_title" => "What is your return policy for clothing items?",
                "slug" => "what-is-your-return-policy-for-clothing-items?",
                "faq_description" => "We offer a hassle-free return policy for clothing purchases. If you are not completely satisfied with your clothing item, you can return it within 30 days of purchase, as long as the item is in its original condition with tags attached. For detailed information on our return process, please refer to our Returns and Exchanges page. ",
                "faq_type" => "shop",
                "issued_by" => $this->shops[2] ?? '',
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            [
                "user_id" => 1,
                "shop_id" => 2,
                "faq_title" => "Do you offer plus-size or petite clothing options?",
                "slug" => "do-you-offer-plus-size-or-petite-clothing-options?",
                "faq_description" => "Yes, we strive to provide a diverse range of clothing sizes to accommodate all body types. Our inventory includes a selection of plus-size and petite clothing options in various styles and designs. You can use our size filters or contact our customer support for assistance in finding the perfect fit. ",
                "faq_type" => "shop",
                "issued_by" => $this->shops[2] ?? '',
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            [
                "user_id" => 1,
                "shop_id" => 11,
                "faq_title" => "How can I determine the right size and style of bag for my needs when shopping online?",
                "slug" => "how-can-i-determine-the-right-size-and-style-of-bag-for-my-needs-when-shopping-online?",
                "faq_description" => "Finding the perfect bag online is made easier with our selection and helpful tools. Here's how to make an informed choice. Each bag product on our website includes detailed descriptions, including dimensions, capacity, and features. Read these descriptions carefully to understand the size and functionality of the bag. We provide high-quality images and, in some cases, videos that showcase the bag from different angles and show it in use. Visual aids can help you assess the bag's size and style better. Check out reviews and ratings from other customers who have purchased the same bag. Feedback from others who have used the bag for various purposes can provide valuable insights. We may offer size guides or charts to help you understand the bag's dimensions in relation to common items you might carry, such as laptops, books, or clothing. If you have specific questions or need personalized recommendations, our customer support team is here to assist you. Use our live chat feature or contact us via email or phone for expert guidance. Rest assured that we have a flexible returns and exchanges policy. If the bag doesn't meet your expectations, you can usually return or exchange it within a specified time frame.  ",
                "faq_type" => "shop",
                "issued_by" => $this->shops[11] ?? '',
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            [
                "user_id" => 1,
                "shop_id" => 11,
                "faq_title" => "What measures do you take to ensure the quality and durability of the bags you sell online?",
                "slug" => "what-measures-do-you-take-to-ensure-the-quality-and-durability-of-the-bags-you-sell-online?",
                "faq_description" => "We are committed to providing high-quality and durable bags to our customers. Here's how we ensure the quality and durability of the bags in our online shop. We carefully curate our collection from reputable brands known for their craftsmanship and quality. We partner with brands that have a strong track record in producing durable and long-lasting bags. Each bag product listing includes detailed information about the materials used in its construction. This allows you to assess the bag's durability and suitability for your needs. Many of our bags come with manufacturer warranties that cover defects in materials and workmanship. Check the product listing for warranty details. We value customer feedback and consider it when selecting bags for our inventory. Positive reviews and high ratings from satisfied customers are indicative of product quality. In the rare event that you receive a bag with defects or quality issues, our returns and exchanges policy allows you to return or exchange the product for your peace of mind. ",
                "faq_type" => "shop",
                "issued_by" => $this->shops[11] ?? '',
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            [
                "user_id" => 1,
                "shop_id" => 4,
                "faq_title" => "How can I find the right makeup products for my skin tone and type when shopping online?",
                "slug" => "how-can-i-find-the-right-makeup-products-for-my-skin-tone-and-type-when-shopping-online?",
                "faq_description" => "Shopping for makeup online is made easier with our website's tools and resources to help you find the perfect products for your skin. Here's how to get started. Each makeup product on our website includes detailed descriptions, including shade names, undertones, and ingredients. Read these descriptions carefully to find products that match your skin tone and type. We offer shade matching tools and guides for foundations, concealers, and other complexion products. These tools can help you identify your ideal shade based on your skin undertones. Check out product reviews and ratings left by other customers who have similar skin tones or concerns. Their feedback can provide valuable insights into how a product performs. If you're unsure about a product or need personalized recommendations, our customer support team is here to assist you. Use our live chat or contact us via email or phone for expert guidance.  We may offer sample sizes or testers for select products. Trying out samples can be a great way to test shades and formulas before committing to a full-sized product. Rest assured that we have a flexible returns and exchanges policy. If a product doesn't meet your expectations, you can usually return or exchange it within a specified time frame.",
                "faq_type" => "shop",
                "issued_by" => $this->shops[4] ?? '',
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            [
                "user_id" => 1,
                "shop_id" => 4,
                "faq_title" => "How do I ensure the authenticity and quality of the makeup products purchased online?",
                "slug" => "how-do-i-ensure-the-authenticity-and-quality-of-the-makeup-products-purchased-online?",
                "faq_description" => "We prioritize the authenticity and quality of all our makeup products to ensure a positive shopping experience. Here's how we guarantee the authenticity and quality of our products. We are an authorized retailer for all the brands and products we carry. This means that we source our products directly from reputable manufacturers and distributors. Makeup products are delivered in their original, sealed packaging. We do not sell opened or tampered products. We only carry well-known and trusted makeup brands with a proven track record for quality and safety. Each product listing on our website includes detailed information, including brand, ingredients, and usage instructions, to help you make an informed decision. We value customer feedback and take it into account when selecting products for our inventory. Positive reviews and high ratings from satisfied customers are indicative of product quality.  In the unlikely event that you receive a product that doesn't meet your expectations, our flexible returns and exchanges policy allows you to return or exchange it for your peace of mind. ",
                "faq_type" => "shop",
                "issued_by" => $this->shops[4] ?? '',
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            [
                "user_id" => 1,
                "shop_id" => 5,
                "faq_title" => "How do I place an order for bakery products on your website?",
                "slug" => "how-do-i-place-an-order-for-bakery-products-on-your-website?",
                "faq_description" => "Ordering delicious bakery products from our online shop is easy and convenient. Here's a step-by-step guide to placing an order: Visit our website to explore our mouthwatering range of bakery products. You can browse by category, including bread, pastries, cakes, and more. Click on the items you'd like to purchase to view detailed descriptions, prices, and available options (e.g., flavors, sizes, and quantities). Add your desired products to your virtual shopping cart.  Before proceeding to checkout, review the items in your cart to ensure you've selected everything you want. You can make adjustments, update quantities, or remove items as needed. When you're ready to complete your order, proceed to the checkout page. Here, you'll provide your delivery information and select your preferred delivery date and time slot. Choose your preferred payment method, such as credit/debit card or digital wallet, and securely enter your payment details. After successful payment, you'll receive an order confirmation via email or SMS. This confirmation will include the details of your order, delivery date, and a unique order number. On the scheduled delivery date, our team will carefully prepare your bakery items and deliver them to your doorstep. You'll receive a notification when your order is on its way. Once your delicious bakery treats arrive, simply unpack and enjoy your freshly baked goodies. ",
                "faq_type" => "shop",
                "issued_by" => $this->shops[5] ?? '',
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            [
                "user_id" => 1,
                "shop_id" => 5,
                "faq_title" => "Do you accommodate special dietary needs or allergies?",
                "slug" => "do-you-accommodate-special-dietary-needs-or-allergies?",
                "faq_description" => "Yes, we strive to accommodate various dietary needs and allergies to ensure that everyone can enjoy our bakery products. Here's how we address specific dietary requirements: Each product on our website includes detailed information about allergens, such as nuts, dairy, eggs, and gluten. You can check these allergen labels to make informed choices. We offer a selection of products tailored to specific dietary preferences and restrictions. This may include gluten-free, vegan, or sugar-free options. You can easily filter products by dietary category on our website to find suitable choices. In some cases, we may be able to customize certain products to meet your specific dietary needs. If you have a special request or dietary requirement, please reach out to our customer support team, and we'll do our best to assist you. ",
                "faq_type" => "shop",
                "issued_by" => $this->shops[5] ?? '',
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            [
                "user_id" => 1,
                "shop_id" => 6,
                "faq_title" => "How does the online ordering and delivery process work?",
                "slug" => "how-does-the-online-ordering-and-delivery-process-work?",
                "faq_description" => "Ordering groceries online with us is simple and convenient. Here's a step-by-step guide to our process:  Visit our website or mobile app to browse our wide selection of groceries. You can search for specific items or explore categories. Add the products you need to your virtual shopping cart.  Before checkout, review your cart to ensure you have everything you need. You can also customize your order, specify quantities, and make any necessary adjustments.  Proceed to the checkout page to review your order one last time. You can choose your preferred payment method, including credit/debit cards or digital wallets, and complete the transaction securely. Select your preferred delivery time slot. We offer flexible delivery options to accommodate your schedule. Once your order is placed, you will receive an order confirmation via email or SMS. You can track the status of your order through your account. Our dedicated delivery team will carefully pack your groceries and deliver them to your doorstep at the chosen time. You'll receive a notification when your order is out for delivery.  Receive your groceries, unpack, and enjoy your fresh and quality products. ",
                "faq_type" => "shop",
                "issued_by" => $this->shops[6] ?? '',
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            [
                "user_id" => 1,
                "shop_id" => 6,
                "faq_title" => "What are the delivery fees and minimum order requirements?",
                "slug" => "what-are-the-delivery-fees-and-minimum-order-requirements?",
                "faq_description" => "We aim to provide affordable and convenient online grocery shopping. Our delivery fees and minimum order requirements are as follows: The delivery fee may vary depending on your location and the time slot you choose. We strive to keep our delivery charges competitive and transparent. You can view the applicable fees during the checkout process. To place an order for delivery, we have a minimum order requirement. This requirement helps us cover the costs associated with packing and delivering your groceries. The minimum order amount may vary based on your location, but you can easily check the specific minimum for your area on our website or app. Please note that we may offer promotions and discounts from time to time, including waived delivery fees for orders over a certain amount. Keep an eye out for these special offers to save even more on your online grocery shopping. ",
                "faq_type" => "shop",
                "issued_by" => $this->shops[6] ?? '',
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            [
                "user_id" => 1,
                "shop_id" => 7,
                "faq_title" => "Can I order both physical books and e-books from your store?",
                "slug" => "can-i-order-both-physical-books-and-e-books-from-your-store?",
                "faq_description" => "Yes, you can choose from a wide selection of physical books and e-books in our store. Simply browse our catalog and select your preferred format for each title. Physical books will be delivered to your address, while e-books can be downloaded instantly upon purchase.",
                "faq_type" => "shop",
                "issued_by" => $this->shops[7] ?? '',
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            [
                "user_id" => 1,
                "shop_id" => 7,
                "faq_title" => "Do you offer book recommendations or have a book club?",
                "slug" => "do-you-offer-book-recommendations-or-have-a-book-club?",
                "faq_description" => "We love books, and we're here to help you discover new reads! You can explore our Recommended Reads section for curated book recommendations. Additionally, we periodically host virtual book club events where readers can discuss and explore books together. Stay tuned for announcements on our website or social media.",
                "faq_type" => "shop",
                "issued_by" => $this->shops[7] ?? '',
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            [
                "user_id" => 1,
                "shop_id" => 8,
                "faq_title" => "Do you provide warranty coverage for electronic gadgets?",
                "slug" => "do-you-provide-warranty-coverage-for-electronic-gadgets?",
                "faq_description" => "Yes, most electronic gadgets come with manufacturer warranties that cover defects and malfunctions. The warranty duration and terms vary by product and brand. You can find warranty information in the product descriptions or contact our customer support for specific details.",
                "faq_type" => "shop",
                "issued_by" => $this->shops[8] ?? '',
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            [
                "user_id" => 1,
                "shop_id" => 8,
                "faq_title" => "Are your gadgets brand new, or do you offer refurbished options as well?",
                "slug" => "are-your-gadgets-brand-new,-or-do-you-offer-refurbished-options-as-well?",
                "faq_description" => "We primarily offer brand new gadgets, but we may occasionally have certified refurbished options available. Each product listing will specify whether it is new or refurbished. Refurbished gadgets undergo thorough testing and quality checks to ensure they meet high standards. ",
                "faq_type" => "shop",
                "issued_by" => $this->shops[8] ?? '',
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            [
                "user_id" => 1,
                "shop_id" => 9,
                "faq_title" => "Can I order prescription medications from your online medicine shop?",
                "slug" => "can-i-order-prescription-medications-from-your-online-medicine-shop?",
                "faq_description" => "We do not offer prescription medications. Our shop specializes in over-the-counter (OTC) and wellness products. Please consult a healthcare professional for prescription medications and guidance. ",
                "faq_type" => "shop",
                "issued_by" => $this->shops[9] ?? '',
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            [
                "user_id" => 1,
                "shop_id" => 9,
                "faq_title" => "What measures do you take to ensure the authenticity and safety of the medicines you sell?",
                "slug" => "what-measures-do-you-take-to-ensure-the-authenticity-and-safety-of-the-medicines-you-sell?",
                "faq_description" => "We work exclusively with trusted suppliers and brands to ensure the authenticity and safety of the medicines and wellness products in our inventory. All products are sourced from licensed manufacturers and adhere to strict quality and safety standards. ",
                "faq_type" => "shop",
                "issued_by" => $this->shops[9] ?? '',
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            [
                "user_id" => 1,
                "shop_id" => 10,
                "faq_title" => "Can I return baby care items if they are unopened and unused?",
                "slug" => "can-i-return-baby-care-items-if-they-are-unopened-and-unused?",
                "faq_description" => "Yes, you can return unopened and unused baby care items within 30 days of purchase. We prioritize the safety and satisfaction of our customers, and our return policy reflects that commitment.",
                "faq_type" => "shop",
                "issued_by" => $this->shops[10] ?? '',
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            [
                "user_id" => 1,
                "shop_id" => 10,
                "faq_title" => "Are your baby care products free from harmful chemicals and safe for infants?",
                "slug" => "are-your-baby-care-products-free-from-harmful-chemicals-and-safe-for-infants?",
                "faq_description" => "Absolutely. We source baby care products from reputable brands known for their commitment to safety and quality. All our products comply with safety standards and are free from harmful chemicals. You can find detailed ingredient information on product labels and descriptions. ",
                "faq_type" => "shop",
                "issued_by" => $this->shops[10] ?? '',
                "language" => "en",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],

            // [
            //     "user_id" => 1,
            //     "shop_id" => 12,
            //     "faq_title" => "Do you offer installation services for home appliances?",
            //     "slug" => "do-you-offer-installation-services-for-home-appliances?",
            //     "faq_description" => "Yes, we provide installation services for many home appliances. During the checkout process, you can select the option for installation if available for your chosen product. Our skilled technicians will ensure a safe and proper installation. ",
            //     "faq_type" => "shop",
            //     "issued_by" => "Home Appliance Shop",
            //     "language" => "en",
            //     'created_at' => Carbon::now(),
            //     'updated_at' => Carbon::now(),
            //     'deleted_at' => null,
            // ],
            // [
            //     "user_id" => 1,
            //     "shop_id" => 12,
            //     "faq_title" => "What is the warranty coverage for home appliances?",
            //     "slug" => "what-is-the-warranty-coverage-for-home-appliances?",
            //     "faq_description" => "Most home appliances come with manufacturer warranties that cover defects and malfunctions. Warranty terms and durations vary by product and brand. You can find warranty information in the product descriptions or contact our customer support for specific details. ",
            //     "faq_type" => "shop",
            //     "issued_by" => "Home Appliance Shop",
            //     "language" => "en",
            //     'created_at' => Carbon::now(),
            //     'updated_at' => Carbon::now(),
            //     'deleted_at' => null,
            // ],
            // [
            //     "user_id" => 1,
            //     "shop_id" => 13,
            //     "faq_title" => "How do I care for microgreens once they are delivered?",
            //     "slug" => "how-do-i-care-for-microgreens-once-they-are-delivered?",
            //     "faq_description" => "Micro greens are easy to care for. Upon delivery, place them in a well-lit area, preferably near a window with indirect sunlight. Water them lightly as needed to keep the soil evenly moist, but avoid over watering. ",
            //     "faq_type" => "shop",
            //     "issued_by" => "Micro Green Shop",
            //     "language" => "en",
            //     'created_at' => Carbon::now(),
            //     'updated_at' => Carbon::now(),
            //     'deleted_at' => null,
            // ],
            // [
            //     "user_id" => 1,
            //     "shop_id" => 13,
            //     "faq_title" => "Can I grow microgreens indoors year-round?",
            //     "slug" => "can-i-grow-microgreens-indoors-year-round?",
            //     "faq_description" => "Yes, you can! Micro greens are well-suited for indoor cultivation, allowing you to enjoy fresh greens throughout the year. With the right conditions and care, you can have a continuous supply of homegrown micro greens. ",
            //     "faq_type" => "shop",
            //     "issued_by" => "Micro Green Shop",
            //     "language" => "en",
            //     'created_at' => Carbon::now(),
            //     'updated_at' => Carbon::now(),
            //     'deleted_at' => null,
            // ],
            // [
            //     "user_id" => 1,
            //     "shop_id" => 14,
            //     "faq_title" => "What care instructions are provided with the plants I purchase?",
            //     "slug" => "what-care-instructions-are-provided-with-the-plants-i-purchase?",
            //     "faq_description" => "Each plant comes with care instructions specific to its type. These instructions include details on sunlight requirements, watering schedules, and general plant care tips. You can also find additional care resources on our website.",
            //     "faq_type" => "shop",
            //     "issued_by" => "Plants Shop",
            //     "language" => "en",
            //     'created_at' => Carbon::now(),
            //     'updated_at' => Carbon::now(),
            //     'deleted_at' => null,
            // ],
            // [
            //     "user_id" => 1,
            //     "shop_id" => 14,
            //     "faq_title" => "Do you offer a guarantee on the health of the plants upon delivery?",
            //     "slug" => "do-you-offer-a-guarantee-on-the-health-of-the-plants-upon-delivery?",
            //     "faq_description" => "We take great care in packaging and shipping plants to ensure their health upon arrival. If you receive a plant in unsatisfactory condition, please contact us within 48 hours of delivery with photos, and we will work to resolve the issue promptly. Your satisfaction is important to us. ",
            //     "faq_type" => "shop",
            //     "issued_by" => "Plants Shop",
            //     "language" => "en",
            //     'created_at' => Carbon::now(),
            //     'updated_at' => Carbon::now(),
            //     'deleted_at' => null,
            // ],
        ];
    }


    private function shopFAQsSeederGerman(): array
    {
        if (!TRANSLATION_ENABLED) {
            return [];
        } else {
            return [
                [
                    "user_id" => 1,
                    "shop_id" => null,
                    "faq_title" => "Wie lauten Ihre Rückgabebedingungen?",
                    "slug" => "wie-lauten-ihre-rückgabebedingungen?",
                    "faq_description" => "Wir haben ein flexibles Rückgaberecht. Wenn Sie mit Ihrem Kauf nicht zufrieden sind, können Sie die meisten Artikel innerhalb von 30 Tagen gegen eine vollständige Rückerstattung oder einen Umtausch zurückgeben. Weitere Informationen finden Sie in unseren Rückgabebedingungen.",
                    "faq_type" => "global",
                    "issued_by" => "Super Admin",
                    "language" => "de",
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'deleted_at' => null,
                ],
                [
                    "user_id" => 1,
                    "shop_id" => null,
                    "faq_title" => "Kann ich meine Bestellung verfolgen?",
                    "slug" => "kann-ich-meine-bestellung-verfolgen?",
                    "faq_description" => "Ja, Sie können den Status Ihrer Bestellung verfolgen. Sobald Ihre Bestellung versandt wurde, erhalten Sie per E-Mail eine Sendungsverfolgungsnummer. Mithilfe dieser Sendungsverfolgungsnummer können Sie den Fortschritt Ihrer Lieferung überwachen.",
                    "faq_type" => "global",
                    "issued_by" => "Super Admin",
                    "language" => "de",
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'deleted_at' => null,
                ],
                [
                    "user_id" => 1,
                    "shop_id" => null,
                    "faq_title" => "Wie lange dauert es, bis ich meine Bestellung erhalte?",
                    "slug" => "wie-lange-dauert-es,-bis-ich-meine-bestellung-erhalte?",
                    "faq_description" => "Die Lieferzeiten können je nach Standort und gewählter Versandart variieren. Normalerweise werden Bestellungen innerhalb von 1-2 Werktagen bearbeitet und versendet. Sie können die voraussichtliche Lieferzeit beim Bezahlvorgang überprüfen.",
                    "faq_type" => "global",
                    "issued_by" => "Super Admin",
                    "language" => "de",
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'deleted_at' => null,
                ],
                [
                    "user_id" => 1,
                    "shop_id" => null,
                    "faq_title" => "Welche Zahlungsmethoden werden akzeptiert?",
                    "slug" => "welche-zahlungsmethoden-werden-akzeptiert?",
                    "faq_description" => "Wir akzeptieren eine Vielzahl von Zahlungsmethoden, darunter Kreditkarten (Visa, MasterCard, American Express), PayPal und mehr. Während des Bestellvorgangs können Sie Ihre bevorzugte Zahlungsoption auswählen.",
                    "faq_type" => "global",
                    "issued_by" => "Super Admin",
                    "language" => "de",
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'deleted_at' => null,
                ],
                [
                    "user_id" => 1,
                    "shop_id" => null,
                    "faq_title" => "Wie kann ich eine Bestellung aufgeben?",
                    "slug" => "wie-kann-ich-eine-bestellung-aufgeben?",
                    "faq_description" => "Um eine Bestellung aufzugeben, stöbern Sie einfach in unserem Online-Shop, legen Sie die gewünschten Artikel in Ihren Warenkorb und gehen Sie zur Kasse. Befolgen Sie die Anweisungen zur Eingabe Ihrer Versandinformationen und Zahlungsdetails, um Ihren Kauf abzuschließen.",
                    "faq_type" => "global",
                    "issued_by" => "Super Admin",
                    "language" => "de",
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'deleted_at' => null,
                ],
                [
                    "user_id" => 1,
                    "shop_id" => 1,
                    "faq_title" => "Wie läuft der Lieferprozess beim Möbelkauf ab?",
                    "slug" => "wie-läuft-der-lieferprozess-beim-möbelkauf-ab?",
                    "faq_description" => "Wir bieten bequeme und zuverlässige Möbellieferdienste. Nach dem Kauf wird sich unser Team mit Ihnen in Verbindung setzen, um einen Liefertermin zu vereinbaren, der Ihrer Verfügbarkeit entspricht. Unsere Lieferprofis montieren und stellen die Möbel in Ihrem Wunschraum auf. Weitere Informationen finden Sie auf unserer Seite mit den Lieferinformationen.",
                    "faq_type" => "shop",
                    "issued_by" => $this->shops[1] ?? '',
                    "language" => "de",
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'deleted_at' => null,
                ],
                [
                    "user_id" => 1,
                    "shop_id" => 1,
                    "faq_title" => "Bieten Sie eine Garantie für Möbelstücke an?",
                    "slug" => "bieten-sie-eine-garantie-für-möbelstücke-an?",
                    "faq_description" => "Ja, für viele unserer Möbelstücke gilt eine Herstellergarantie, die strukturelle Mängel und Verarbeitungsfehler abdeckt. Die Dauer und Bedingungen der Garantie können je nach Produkt variieren. Informationen zur Garantie finden Sie in den Produktbeschreibungen. Für spezifische Details können Sie sich auch an unseren Kundendienst wenden.",
                    "faq_type" => "shop",
                    "issued_by" => $this->shops[1] ?? '',
                    "language" => "de",
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'deleted_at' => null,
                ],
                [
                    "user_id" => 1,
                    "shop_id" => 2,
                    "faq_title" => "Wie lauten Ihre Rückgabebedingungen für Kleidungsstücke?",
                    "slug" => "wie-lauten-ihre-rückgabebedingungen-für-kleidungsstücke?",
                    "faq_description" => "Wir bieten ein problemloses Rückgaberecht für den Kauf von Kleidung. Wenn Sie mit Ihrem Kleidungsstück nicht vollständig zufrieden sind, können Sie es innerhalb von 30 Tagen nach dem Kauf zurückgeben, sofern sich das Kleidungsstück im Originalzustand mit angebrachten Etiketten befindet. Ausführliche Informationen zu unserem Rückgabeprozess finden Sie auf unserer Seite „Rückgaben und Umtausch“.",
                    "faq_type" => "shop",
                    "issued_by" => $this->shops[2] ?? '',
                    "language" => "de",
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'deleted_at' => null,
                ],
                [
                    "user_id" => 1,
                    "shop_id" => 2,
                    "faq_title" => "Bieten Sie Kleidung in Übergrößen oder Petite-Größen an?",
                    "slug" => "bieten-sie-kleidung-in-übergrößen-oder-petite-größen-an?",
                    "faq_description" => "Ja, wir sind bestrebt, ein vielfältiges Sortiment an Konfektionsgrößen für alle Körpertypen anzubieten. Unser Sortiment umfasst eine Auswahl an Kleidung in Übergrößen und Petite-Größen in verschiedenen Stilen und Designs. Sie können unsere Größenfilter verwenden oder sich an unseren Kundensupport wenden, um Hilfe bei der Suche nach der perfekten Passform zu erhalten.",
                    "faq_type" => "shop",
                    "issued_by" => $this->shops[2] ?? '',
                    "language" => "de",
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'deleted_at' => null,
                ],
                [
                    "user_id" => 1,
                    "shop_id" => 11,
                    "faq_title" => "Wie kann ich beim Online-Einkauf die richtige Taschengröße und den richtigen Taschenstil für meine Bedürfnisse ermitteln?",
                    "slug" => "wie-kann-ich-beim-online-einkauf-die-richtige-taschengröße-und-den-richtigen-taschenstil-für-meine-bedürfnisse-ermitteln?",
                    "faq_description" => "Mit unserer Auswahl und hilfreichen Tools wird es einfacher, online die perfekte Tasche zu finden. So treffen Sie eine fundierte Entscheidung. Jedes Taschenprodukt auf unserer Website enthält detaillierte Beschreibungen, einschließlich Abmessungen, Kapazität und Funktionen. Lesen Sie diese Beschreibungen sorgfältig durch, um die Größe und Funktionalität der Tasche zu verstehen. Wir stellen hochwertige Bilder und teilweise auch Videos zur Verfügung, die die Tasche aus verschiedenen Blickwinkeln zeigen und sie im Einsatz zeigen. Mithilfe visueller Hilfsmittel können Sie die Größe und den Stil der Tasche besser einschätzen. Schauen Sie sich die Rezensionen und Bewertungen anderer Kunden an, die die gleiche Tasche gekauft haben. Rückmeldungen von anderen, die die Tasche für verschiedene Zwecke verwendet haben, können wertvolle Erkenntnisse liefern. Möglicherweise bieten wir Größenleitfäden oder -tabellen an, um Ihnen zu helfen, die Abmessungen der Tasche im Verhältnis zu den üblichen Gegenständen zu verstehen, die Sie möglicherweise mit sich führen, wie z. B. Laptops, Bücher oder Kleidung. Wenn Sie spezielle Fragen haben oder individuelle Empfehlungen benötigen, steht Ihnen unser Kundensupport-Team gerne zur Verfügung. Nutzen Sie unsere Live-Chat-Funktion oder kontaktieren Sie uns per E-Mail oder Telefon für eine fachkundige Beratung. Seien Sie versichert, dass wir über eine flexible Rückgabe- und Umtauschrichtlinie verfügen. Sollte die Tasche nicht Ihren Erwartungen entsprechen, können Sie sie in der Regel innerhalb einer bestimmten Frist zurückgeben oder umtauschen.",
                    "faq_type" => "shop",
                    "issued_by" => $this->shops[11] ?? '',
                    "language" => "de",
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'deleted_at' => null,
                ],
                [
                    "user_id" => 1,
                    "shop_id" => 11,
                    "faq_title" => "Welche Maßnahmen ergreifen Sie, um die Qualität und Haltbarkeit der Taschen, die Sie online verkaufen, sicherzustellen?",
                    "slug" => "welche-maßnahmen-ergreifen-sie,-um-die-qualität-und-haltbarkeit-der-taschen,-die-sie-online-verkaufen,-sicherzustellen?",
                    "faq_description" => "Wir sind bestrebt, unseren Kunden hochwertige und langlebige Taschen anzubieten. So stellen wir die Qualität und Langlebigkeit der Taschen in unserem Onlineshop sicher. Wir stellen unsere Kollektion sorgfältig aus renommierten Marken zusammen, die für ihre Handwerkskunst und Qualität bekannt sind. Wir arbeiten mit Marken zusammen, die eine starke Erfolgsbilanz bei der Herstellung robuster und langlebiger Taschen vorweisen können. Jede Produktliste einer Tasche enthält detaillierte Informationen zu den bei der Herstellung verwendeten Materialien. Dadurch können Sie die Haltbarkeit und Eignung der Tasche für Ihre Bedürfnisse beurteilen. Für viele unserer Taschen gilt eine Herstellergarantie, die Material- und Verarbeitungsfehler abdeckt. Einzelheiten zur Garantie finden Sie in der Produktliste. Wir legen Wert auf Kundenfeedback und berücksichtigen es bei der Auswahl der Taschen für unseren Bestand. Positive Rezensionen und hohe Bewertungen zufriedener Kunden zeugen von der Produktqualität. Für den seltenen Fall, dass Sie eine Tasche mit Mängeln oder Qualitätsproblemen erhalten, können Sie das Produkt dank unserer Rückgabe- und Umtauschrichtlinie beruhigt zurückgeben oder umtauschen.",
                    "faq_type" => "shop",
                    "issued_by" => $this->shops[11] ?? '',
                    "language" => "de",
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'deleted_at' => null,
                ],
                [
                    "user_id" => 1,
                    "shop_id" => 4,
                    "faq_title" => "Wie finde ich beim Online-Shopping die richtigen Make-up-Produkte für meinen Hautton und -typ?",
                    "slug" => "wie-finde-ich-beim-online-shopping-die-richtigen-make-up-produkte-für-meinen-hautton-und--typ?",
                    "faq_description" => "Der Online-Einkauf von Make-up wird mit den Tools und Ressourcen unserer Website einfacher, die Ihnen dabei helfen, die perfekten Produkte für Ihre Haut zu finden. Hier erfahren Sie, wie Sie beginnen. Jedes Make-up-Produkt auf unserer Website enthält detaillierte Beschreibungen, einschließlich Farbnamen, Untertönen und Inhaltsstoffen. Lesen Sie diese Beschreibungen sorgfältig durch, um Produkte zu finden, die zu Ihrem Hautton und -typ passen. Wir bieten Farbanpassungstools und Anleitungen für Grundierungen, Concealer und andere Teintprodukte. Mithilfe dieser Tools können Sie Ihren idealen Farbton anhand Ihres Hautuntertons ermitteln. Sehen Sie sich Produktrezensionen und Bewertungen anderer Kunden an, die ähnliche Hauttöne oder Bedenken haben. Ihr Feedback kann wertvolle Erkenntnisse über die Leistung eines Produkts liefern. Wenn Sie sich bei einem Produkt unsicher sind oder individuelle Empfehlungen benötigen, steht Ihnen unser Kundensupport-Team gerne zur Seite. Nutzen Sie unseren Live-Chat oder kontaktieren Sie uns per E-Mail oder Telefon für eine fachkundige Beratung. Für ausgewählte Produkte bieten wir möglicherweise Mustergrößen oder Tester an. Das Ausprobieren von Mustern kann eine gute Möglichkeit sein, Farbtöne und Formeln zu testen, bevor Sie sich für ein Produkt in Originalgröße entscheiden. Seien Sie versichert, dass wir über eine flexible Rückgabe- und Umtauschrichtlinie verfügen. Wenn ein Produkt nicht Ihren Erwartungen entspricht, können Sie es in der Regel innerhalb einer bestimmten Frist zurückgeben oder umtauschen.",
                    "faq_type" => "shop",
                    "issued_by" => $this->shops[4] ?? '',
                    "language" => "de",
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'deleted_at' => null,
                ],
                [
                    "user_id" => 1,
                    "shop_id" => 4,
                    "faq_title" => "Wie stelle ich die Authentizität und Qualität der online gekauften Make-up-Produkte sicher?",
                    "slug" => "wie-stelle-ich-die-authentizität-und-qualität-der-online-gekauften-make-up-produkte-sicher?",
                    "faq_description" => "Wir legen großen Wert auf Authentizität und Qualität aller unserer Make-up-Produkte, um ein positives Einkaufserlebnis zu gewährleisten. So garantieren wir die Echtheit und Qualität unserer Produkte. Wir sind autorisierter Händler für alle von uns geführten Marken und Produkte. Das bedeutet, dass wir unsere Produkte direkt von namhaften Herstellern und Händlern beziehen. Make-up-Produkte werden in der originalen, versiegelten Verpackung geliefert. Wir verkaufen keine geöffneten oder manipulierten Produkte. Wir führen nur bekannte und vertrauenswürdige Make-up-Marken mit nachweislicher Erfolgsbilanz in Bezug auf Qualität und Sicherheit. Jede Produktliste auf unserer Website enthält detaillierte Informationen, einschließlich Marke, Inhaltsstoffe und Gebrauchsanweisungen, um Ihnen zu helfen, eine fundierte Entscheidung zu treffen. Wir legen Wert auf Kundenfeedback und berücksichtigen es bei der Auswahl der Produkte für unseren Bestand. Positive Rezensionen und hohe Bewertungen zufriedener Kunden zeugen von der Produktqualität. Für den unwahrscheinlichen Fall, dass Sie ein Produkt erhalten, das nicht Ihren Erwartungen entspricht, können Sie es dank unserer flexiblen Rückgabe- und Umtauschrichtlinie beruhigt zurückgeben oder umtauschen.",
                    "faq_type" => "shop",
                    "issued_by" => $this->shops[4] ?? '',
                    "language" => "de",
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'deleted_at' => null,
                ],
                [
                    "user_id" => 1,
                    "shop_id" => 5,
                    "faq_title" => "Wie bestelle ich Backwaren auf Ihrer Website?",
                    "slug" => "wie-bestelle-ich-backwaren-auf-ihrer-website?",
                    "faq_description" => "Die Bestellung köstlicher Backwaren in unserem Online-Shop ist einfach und bequem. Hier finden Sie eine Schritt-für-Schritt-Anleitung zum Aufgeben einer Bestellung: Besuchen Sie unsere Website, um unser köstliches Sortiment an Backwaren zu entdecken. Sie können nach Kategorien suchen, einschließlich Brot, Gebäck, Kuchen und mehr. Klicken Sie auf die Artikel, die Sie kaufen möchten, um detaillierte Beschreibungen, Preise und verfügbare Optionen (z. B. Geschmacksrichtungen, Größen und Mengen) anzuzeigen. Legen Sie Ihre gewünschten Produkte in Ihren virtuellen Warenkorb. Bevor Sie zur Kasse gehen, überprüfen Sie die Artikel in Ihrem Warenkorb, um sicherzustellen, dass Sie alles ausgewählt haben, was Sie möchten. Sie können nach Bedarf Anpassungen vornehmen, Mengen aktualisieren oder Artikel entfernen. Wenn Sie bereit sind, Ihre Bestellung abzuschließen, gehen Sie zur Checkout-Seite. Hier geben Sie Ihre Lieferinformationen ein und wählen Ihr bevorzugtes Lieferdatum und -zeitfenster aus. Wählen Sie Ihre bevorzugte Zahlungsmethode, z. B. Kredit-/Debitkarte oder digitale Geldbörse, und geben Sie Ihre Zahlungsdaten sicher ein. Nach erfolgreicher Zahlung erhalten Sie eine Bestellbestätigung per E-Mail oder SMS. Diese Bestätigung enthält die Einzelheiten Ihrer Bestellung, das Lieferdatum und eine eindeutige Bestellnummer. Zum vereinbarten Liefertermin bereitet unser Team Ihre Backwaren sorgfältig vor und liefert sie an Ihre Haustür. Sie erhalten eine Benachrichtigung, wenn Ihre Bestellung unterwegs ist. Sobald Ihre köstlichen Backwaren angekommen sind, packen Sie sie einfach aus und genießen Sie Ihre frisch gebackenen Leckereien.",
                    "faq_type" => "shop",
                    "issued_by" => $this->shops[5] ?? '',
                    "language" => "de",
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'deleted_at' => null,
                ],
                [
                    "user_id" => 1,
                    "shop_id" => 5,
                    "faq_title" => "Berücksichtigen Sie spezielle Ernährungsbedürfnisse oder Allergien?",
                    "slug" => "berücksichtigen-sie-spezielle-ernährungsbedürfnisse-oder-allergien?",
                    "faq_description" => "Ja, wir sind bestrebt, auf verschiedene Ernährungsbedürfnisse und Allergien einzugehen, um sicherzustellen, dass jeder unsere Backwaren genießen kann. So gehen wir auf spezifische Ernährungsbedürfnisse ein: Jedes Produkt auf unserer Website enthält detaillierte Informationen zu Allergenen wie Nüssen, Milchprodukten, Eiern und Gluten. Sie können diese Allergenetiketten überprüfen, um fundierte Entscheidungen zu treffen. Wir bieten eine Auswahl an Produkten an, die auf spezifische Ernährungspräferenzen und -beschränkungen zugeschnitten sind. Dazu können glutenfreie, vegane oder zuckerfreie Optionen gehören. Sie können Produkte auf unserer Website ganz einfach nach Ernährungskategorie filtern, um die passende Auswahl zu finden. In einigen Fällen können wir möglicherweise bestimmte Produkte an Ihre spezifischen Ernährungsbedürfnisse anpassen. Wenn Sie spezielle Wünsche oder spezielle Ernährungsbedürfnisse haben, wenden Sie sich bitte an unseren Kundendienst. Wir werden unser Bestes tun, um Ihnen zu helfen.",
                    "faq_type" => "shop",
                    "issued_by" => $this->shops[5] ?? '',
                    "language" => "de",
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'deleted_at' => null,
                ],
                [
                    "user_id" => 1,
                    "shop_id" => 6,
                    "faq_title" => "Wie funktioniert der Online-Bestell- und Lieferprozess?",
                    "slug" => "wie-funktioniert-der-online-bestell--und-lieferprozess?",
                    "faq_description" => "Lebensmittel online bei uns zu bestellen ist einfach und bequem. Hier ist eine Schritt-für-Schritt-Anleitung für unseren Prozess: Besuchen Sie unsere Website oder mobile App, um unsere große Auswahl an Lebensmitteln zu durchsuchen. Sie können nach bestimmten Artikeln suchen oder Kategorien erkunden. Legen Sie die benötigten Produkte in Ihren virtuellen Warenkorb. Überprüfen Sie vor dem Bezahlen Ihren Warenkorb, um sicherzustellen, dass Sie alles haben, was Sie brauchen. Sie können Ihre Bestellung auch individuell anpassen, Mengen angeben und alle erforderlichen Anpassungen vornehmen. Gehen Sie zur Checkout-Seite, um Ihre Bestellung ein letztes Mal zu überprüfen. Sie können Ihre bevorzugte Zahlungsmethode auswählen, einschließlich Kredit-/Debitkarten oder digitale Geldbörsen, und die Transaktion sicher abschließen. Wählen Sie Ihr bevorzugtes Lieferzeitfenster. Wir bieten flexible Lieferoptionen, um Ihrem Zeitplan gerecht zu werden. Sobald Ihre Bestellung aufgegeben wurde, erhalten Sie eine Bestellbestätigung per E-Mail oder SMS. Sie können den Status Ihrer Bestellung über Ihr Konto verfolgen. Unser engagiertes Lieferteam verpackt Ihre Lebensmittel sorgfältig und liefert sie zum gewünschten Zeitpunkt an Ihre Haustür. Sie erhalten eine Benachrichtigung, wenn Ihre Bestellung zur Lieferung bereit ist. Empfangen Sie Ihre Lebensmittel, packen Sie sie aus und genießen Sie Ihre frischen und hochwertigen Produkte.",
                    "faq_type" => "shop",
                    "issued_by" => $this->shops[6] ?? '',
                    "language" => "de",
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'deleted_at' => null,
                ],
                [
                    "user_id" => 1,
                    "shop_id" => 6,
                    "faq_title" => "Wie hoch sind die Liefergebühren und Mindestbestellanforderungen?",
                    "slug" => "wie-hoch-sind-die-liefergebühren-und-mindestbestellanforderungen?",
                    "faq_description" => "Unser Ziel ist es, erschwinglichen und bequemen Online-Lebensmitteleinkauf anzubieten. Unsere Liefergebühren und Mindestbestellanforderungen sind wie folgt: Die Liefergebühr kann je nach Ihrem Standort und dem von Ihnen gewählten Zeitfenster variieren. Wir sind bestrebt, unsere Versandkosten wettbewerbsfähig und transparent zu halten. Die anfallenden Gebühren können Sie während des Bestellvorgangs einsehen. Um eine Bestellung zur Lieferung aufzugeben, gilt eine Mindestbestellmenge. Diese Anforderung hilft uns, die Kosten zu decken, die mit der Verpackung und Lieferung Ihrer Lebensmittel verbunden sind. Der Mindestbestellwert kann je nach Standort variieren, Sie können den spezifischen Mindestbestellwert für Ihre Region jedoch ganz einfach auf unserer Website oder App überprüfen. Bitte beachten Sie, dass wir von Zeit zu Zeit Werbeaktionen und Rabatte anbieten können, einschließlich der Befreiung von den Liefergebühren für Bestellungen über einem bestimmten Bestellwert. Halten Sie Ausschau nach diesen Sonderangeboten, um beim Online-Lebensmitteleinkauf noch mehr zu sparen.",
                    "faq_type" => "shop",
                    "issued_by" => $this->shops[6] ?? '',
                    "language" => "de",
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'deleted_at' => null,
                ],
                [
                    "user_id" => 1,
                    "shop_id" => 7,
                    "faq_title" => "Kann ich in Ihrem Shop sowohl physische Bücher als auch E-Books bestellen?",
                    "slug" => "kann-ich-in-ihrem-shop-sowohl-physische-bücher-als-auch-e-books-bestellen?",
                    "faq_description" => "Ja, Sie können in unserem Shop aus einer großen Auswahl an physischen Büchern und E-Books wählen. Stöbern Sie einfach in unserem Katalog und wählen Sie für jeden Titel Ihr bevorzugtes Format aus. Physische Bücher werden an Ihre Adresse geliefert, während E-Books sofort nach dem Kauf heruntergeladen werden können.",
                    "faq_type" => "shop",
                    "issued_by" => $this->shops[7] ?? '',
                    "language" => "de",
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'deleted_at' => null,
                ],
                [
                    "user_id" => 1,
                    "shop_id" => 7,
                    "faq_title" => "Bieten Sie Buchempfehlungen an oder haben Sie einen Buchclub?",
                    "slug" => "bieten-sie-buchempfehlungen-an-oder-haben-sie-einen-buchclub?",
                    "faq_description" => "Wir lieben Bücher und sind hier, um Ihnen dabei zu helfen, neue Lektüre zu entdecken! In unserem Bereich „Empfohlene Lektüre“ finden Sie kuratierte Buchempfehlungen. Darüber hinaus veranstalten wir regelmäßig virtuelle Buchclub-Veranstaltungen, bei denen Leser gemeinsam über Bücher diskutieren und sie erkunden können. Bleiben Sie dran für Ankündigungen auf unserer Website oder in den sozialen Medien.",
                    "faq_type" => "shop",
                    "issued_by" => $this->shops[7] ?? '',
                    "language" => "de",
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'deleted_at' => null,
                ],
                [
                    "user_id" => 1,
                    "shop_id" => 9,
                    "faq_title" => "Bieten Sie eine Garantie für elektronische Geräte an?",
                    "slug" => "bieten-sie-eine-garantie-für-elektronische-geräte-an?",
                    "faq_description" => "Ja, für die meisten elektronischen Geräte gilt eine Herstellergarantie, die Defekte und Fehlfunktionen abdeckt. Die Garantiedauer und -bedingungen variieren je nach Produkt und Marke. Garantieinformationen finden Sie in den Produktbeschreibungen oder wenden Sie sich für spezifische Details an unseren Kundensupport.",
                    "faq_type" => "shop",
                    "issued_by" => $this->shops[9] ?? '',
                    "language" => "de",
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'deleted_at' => null,
                ],
                [
                    "user_id" => 1,
                    "shop_id" => 9,
                    "faq_title" => "Sind Ihre Geräte brandneu oder bieten Sie auch generalüberholte Optionen an?",
                    "slug" => "sind-ihre-geräte-brandneu-oder-bieten-sie-auch-generalüberholte-optionen-an?",
                    "faq_description" => "Wir bieten in erster Linie brandneue Geräte an, gelegentlich sind jedoch auch zertifizierte, generalüberholte Geräte verfügbar. In jeder Produktliste wird angegeben, ob es sich um ein neues Produkt oder ein generalüberholtes Produkt handelt. Überholte Geräte werden gründlichen Tests und Qualitätskontrollen unterzogen, um sicherzustellen, dass sie hohen Standards entsprechen.",
                    "faq_type" => "shop",
                    "issued_by" => $this->shops[9] ?? '',
                    "language" => "de",
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'deleted_at' => null,
                ],
                [
                    "user_id" => 1,
                    "shop_id" => 10,
                    "faq_title" => "Kann ich in Ihrem Online-Medizinshop verschreibungspflichtige Medikamente bestellen?",
                    "slug" => "kann-ich-in-ihrem-online-medizinshop-verschreibungspflichtige-medikamente-bestellen?",
                    "faq_description" => "Wir bieten keine verschreibungspflichtigen Medikamente an. Unser Shop ist auf rezeptfreie (OTC) und Wellness-Produkte spezialisiert. Für verschreibungspflichtige Medikamente und Ratschläge wenden Sie sich bitte an einen Arzt.",
                    "faq_type" => "shop",
                    "issued_by" => $this->shops[10] ?? '',
                    "language" => "de",
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'deleted_at' => null,
                ],
                [
                    "user_id" => 1,
                    "shop_id" => 10,
                    "faq_title" => "Welche Maßnahmen ergreifen Sie, um die Echtheit und Sicherheit der von Ihnen verkauften Arzneimittel sicherzustellen?",
                    "slug" => "welche-maßnahmen-ergreifen-sie,-um-die-echtheit-und-sicherheit-der-von-ihnen-verkauften-arzneimittel-sicherzustellen?",
                    "faq_description" => "Wir arbeiten ausschließlich mit vertrauenswürdigen Lieferanten und Marken zusammen, um die Authentizität und Sicherheit der Medikamente und Wellnessprodukte in unserem Bestand zu gewährleisten. Alle Produkte stammen von lizenzierten Herstellern und unterliegen strengen Qualitäts- und Sicherheitsstandards.",
                    "faq_type" => "shop",
                    "issued_by" => $this->shops[10] ?? '',
                    "language" => "de",
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'deleted_at' => null,
                ],
            ];
        }
    }
}
